% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-perform.R
\name{req_dry_run}
\alias{req_dry_run}
\title{Perform a dry run}
\usage{
req_dry_run(req, quiet = FALSE, redact_headers = TRUE)
}
\arguments{
\item{req}{A \link{request}.}

\item{quiet}{If \code{TRUE} doesn't print anything.}

\item{redact_headers}{Redact confidential data in the headers? Currently
redacts the contents of the Authorization header to prevent you from
accidentally leaking credentials when debugging/reprexing.}
}
\value{
Invisibly, a list containing information about the request,
including \code{method}, \code{path}, and \code{headers}.
}
\description{
This shows you exactly what httr2 will send to the server, without
actually sending anything. It requires the httpuv package because it
works by sending the real HTTP request to a local webserver, thanks to
the magic of \code{\link[curl:curl_echo]{curl::curl_echo()}}.
}
\examples{
# httr2 adds default User-Agent, Accept, and Accept-Encoding headers
request("http://example.com") |> req_dry_run()

# the Authorization header is automatically redacted to avoid leaking
# credentials on the console
req <- request("http://example.com") |> req_auth_basic("user", "password")
req |> req_dry_run()

# if you need to see it, use redact_headers = FALSE
req |> req_dry_run(redact_headers = FALSE)
}
