% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp.R
\name{response}
\alias{response}
\alias{response_json}
\title{Create a HTTP response for testing}
\usage{
response(
  status_code = 200,
  url = "https://example.com",
  method = "GET",
  headers = list(),
  body = raw(),
  timing = NULL
)

response_json(
  status_code = 200,
  url = "https://example.com",
  method = "GET",
  headers = list(),
  body = list()
)
}
\arguments{
\item{status_code}{HTTP status code. Must be a single integer.}

\item{url}{URL response came from; might not be the same as the URL in
the request if there were any redirects.}

\item{method}{HTTP method used to retrieve the response.}

\item{headers}{HTTP headers. Can be supplied as a raw or character vector
which will be parsed using the standard rules, or a named list.}

\item{body}{The response body. For \code{response_json()}, a R data structure that
will be serialized to JSON.}

\item{timing}{A named numeric vector giving the time taken by various
components.}
}
\value{
An HTTP response: an S3 list with class \code{httr2_response}.
}
\description{
\code{response()} creates a generic response; \code{response_json()} creates a
response with a JSON body, automatically adding the correct \code{Content-Type}
header.

Generally, you should not need to call these function directly; you'll
get a real HTTP response by calling \code{\link[=req_perform]{req_perform()}} and friends. These
function is provided primarily for use in tests; if you are creating
responses for mocked requests, use the lower-level \code{\link[=new_response]{new_response()}}.
}
\examples{
response()
response(404, method = "POST")
response(headers = c("Content-Type: text/html", "Content-Length: 300"))
}
