% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{Pos.band}
\alias{Pos.band}
\title{Find the chromosome, start and end position for cytoband names}
\usage{
Pos.band(bands, build = NULL, dir = NULL, bioC = FALSE)
}
\arguments{
\item{bands}{character, a vector of cytoband labels, chromosome[p/q]xx.xx ; 
e.g, 13q21.31, Yq11.221, 6p23, etc}

\item{build}{character, "hg18" or "hg19" (or 36/37) to show which reference to retrieve. The 
default when build is NULL is to use the build from the current ChipInfo annotation}

\item{dir}{character, 'dir' is the location to download cyto annotation information; if left as
NULL, depending on the value of getOption("save.annot.in.current"), the annotation will either
be saved in the working directory to speed-up subsequent lookups, or deleted after use.}

\item{bioC}{logical, if true then return position information as a GRanges object, else 
a data.frame}
}
\value{
Returns a data.frame with columns 'chr' [chromosome], 'start' [starting position of the
 gene],'end' [end position of the gene] and 'band' [band without the chromosome prefix],
 or if bioC=TRUE, then returns a GRanges object with equivalent information.
 If returning a data.frame, then it will be in the same order as 'bands'. If bioC=TRUE, then
 the result will be in genome order, regardless of the order of 'bands'.
}
\description{
Allows retrieval of the the chromosome position of a karyotype/cytoband label, 
 or vector of such labels. Note that the position returned for bands is not a 
 single point as for SNPs, so the result will be a chromosome, then a position range with
 start and end, and lastly the band without the chromosome prefix
}
\examples{
setwd(tempdir())
Pos.band("1p13.2")
Pos.band("Yq11.221",build=36)
Pos.band("Yq11.221",build=37)
Pos.band(c("13q21.31","1p13.2","2q33.2","6p23"),bioC=TRUE)
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
\seealso{
\code{\link{Chr}}, \code{\link{Pos}}, \code{\link{Pos.gene}}, \code{\link{Band}}, 
\code{\link{Band.gene}}, \code{\link{Band.pos}}, \code{\link{Gene.pos}}
}

