% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.t1d.regions}
\alias{get.t1d.regions}
\title{Obtain a listing of known T1D associated genomic regions}
\usage{
get.t1d.regions(dense.reg = NULL, build = NULL, invert = FALSE)
}
\arguments{
\item{dense.reg}{GRanges or RangedData object, only use if you need to provide for a
build other than 36 or 37 (hg18/hg19).}

\item{build}{e.g, 36/hg18 or 37/hg19, if left as NULL current getOption('ucsc') will
be used.}

\item{invert}{logical, set to TRUE if you wish to get the set of NON-T1D regions.}
}
\value{
a GRanges object with the specified type 1 diabetes (or inverse) ranges
}
\description{
This function uses a full list of ichip dense regions combined with a list of t1d
SNPs to get the t1d regions. For type 1 diabetes researchers.
}
\examples{
\donttest{
# t1d.reg <- get.t1d.regions()
# non.t1d <- get.t1d.regions(build=36,invert=TRUE)
}
}

