% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{plotGeneAnnot}
\alias{plotGeneAnnot}
\title{Plot genes to annotate figures with genomic axes}
\usage{
plotGeneAnnot(chr = 1, scl = c("b", "kb", "mb", "gb"), y.ofs = 0,
  width = NA, txt = T, chr.pos.offset = 0, gs = NULL, build = NULL,
  dir = NULL, box.col = "green", txt.col = "black", join.col = "red",
  ...)
}
\arguments{
\item{chr}{chromosome number/name that the plot-range lies on}

\item{scl}{character, the scale that the x axis uses, ie, "b","kb","mb", or "gb", meaning
base-pairs, kilobases, megabases or gigabase-pairs.}

\item{y.ofs}{numeric, y-axis-offset, depending on what units are on your y-axis,
you may prefer to specify an offset so that the gene annotation is drawn at an appropriate
level on the vertical axis, this value should be the centre of annotation}

\item{width}{depending on the range of your y-axis, you might want to expand or reduce
the vertical width of the gene annotation (in normal graph units), default
when width=NA is 10 percent of the y-axis size.}

\item{txt}{logical, TRUE to include the names of genes on top of their representation
on the plot, or if FALSE, genes are drawn without labels.}

\item{chr.pos.offset}{if for some reason zero on the x-axis is not equal to 'zero' on
the chromsome, then this offset can correct the offset. For instance if you were using
a graph of the whole genome and you were plotting genes on chromosome 10, you would
set this offset to the combined lengths of chromosomes 1-9 to get the start point
in the correct place.}

\item{gs}{GRanges or RangedData object, this is annotation for the location of genes.
This will be retrieved using get.gene.annot() if 'gs' is NULL. THere may be several reasons
for passing an object directly to 'gs'; firstly speed, if making many calls then you won't
need to load the annotation every time; secondly, if you want to use an alternative annotation
you can create your own so long as it is a GRanges/RangedData object and contains a column
called 'gene' (which doesn't strictly have to contain gene labels, it could be any feature
you require, eg., transcript names, etc).}

\item{build}{string, currently 'hg18' or 'hg19' to specify which annotation version to use. 
Default is build-36/hg-18. Will also accept integers 36,37 as alternative arguments.}

\item{dir}{character, location to store file with the gene annotation.
If NULL then getOption("save.annot.in.current")>=1 will result in
this file being stored in the current directory, or if <=0, then this file will not
be stored.}

\item{box.col}{genes are drawn as boxes, this sets the colour of the boxes}

\item{txt.col}{this sets the colour of the label text (Gene names)}

\item{join.col}{for exons, or multipart genes, joins are made between the sections with
a central line, this sets the colour of that line.}

\item{...}{further arguments to 'rect', the graphics function used to plot the 'genes'.}
}
\value{
Returns a data.frame, GRanges or RangedData object, depending on input parameters. Contained
will be HGNC gene labels, chromosome and start and end positions, other information depends on 
specific parameters documented above
}
\description{
Quite often it is helpful to visualize genomic locations in the context of Genes
in the same region. This function makes it simple to overlay genes on plots
where the x-axis is chromosomal location.
}
\examples{
# EXAMPLE PLOT OF SOME SIMULATED SNPS on chr21-p11.1 #
# do we need to require(GenomicRanges)? #
setwd(tempdir())
loc <- c(9.9,10.2)
Band(chr=21,pos=loc*10^6)
rr <- in.window(rranges(50000),chr=21,pos=loc,unit="mb") # make some random MHC ranges
# create some SNPs and plot
rr3 <- rr; end(rr3) <- start(rr3) 
rownames(rr3) <- paste0("rs",sample(10^6,nrow(rr3)))
plotRanges(rr3,col="blue",scl="mb",xlim=loc,xlab="Chr21 position (Mb)",ylab="")
# NOW add UCSC hg18 GENE annotation to the plot #
\donttest{ plotGeneAnnot(chr=21,pos=c(9.95,10.1),scl="mb",y.ofs=1,build=36) }
}

