% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{rangeSnp}
\alias{rangeSnp}
\title{Find closest SNPs to the starts and ends of ranges}
\usage{
rangeSnp(ranged = NULL, snp.info = NULL, chr = NULL, pos = NULL,
  nearest = T)
}
\arguments{
\item{ranged}{A GRanges or RangedData object specifying the range(s) you wish to find SNPs near the
starts/ends of. Alternatively leave this parameter as NULL and specify ranges using chr, pos}

\item{snp.info}{ChipInfo/GRanges/Ranged data object describing the SNPs relevant to your query, e.g, 
SNPs on the chip you are using. If left NULL, the SNP set used will be that retrieved by chip.support()
which will depend on your options() settings, see ?chip.support for more info}

\item{chr}{optional alternative to 'ranged' input, use in conjunction with 'pos' to specify the ranges
to find the SNPs near the starts/ends of.}

\item{pos}{matrix with 2 columns for start, end positions, or a single column if all ranges are SNPs.
An optional alternative to 'ranged' input, use in conjunction with 'chr' to specify the ranges
to find the SNPs near the starts/ends of.}

\item{nearest}{will preferably find an exact match but if nearest=TRUE, will fall-back on nearest match, 
even if slightly outside the range.}
}
\value{
a list of SNP-ids (rownames of 'snp.info') fulfilling the criteria, the output will be a matrix
which should have the same number of rows as the number of ranges entered.
}
\description{
For given genome ranges (GRanges/RangedData) will try to find the closest snps to the starts and ends
of the ranges.
}
\examples{
rangeSnp(chr=c(1:3),pos=cbind(c(100000,200000,300000),c(30000000,4000000,10000000)))
rangeSnp(rranges())
}

