% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{Band}
\alias{Band}
\title{Retrieve the cytoband(s) for snp ids, genes or locations}
\usage{
Band(genes = NULL, chr = NULL, ranges = NULL, snps = NULL,
  build = NULL, dir = NULL, ...)
}
\arguments{
\item{genes}{character, an optional vector of gene ids, or RangedData/GRanges object}

\item{chr}{character, an optional vector of chromosomes to combine with 'pos' or 'start'+'end'
(enter in ...) to describe positions to retrieve the band from}

\item{ranges}{optional GRanges or RangedData object describing positions for which we want bands}

\item{snps}{optional SNP ids, e.g, chip ids or rs-ids, to retrieve the band they fall within}

\item{build}{character, "hg18" or "hg19" (or 36/37) to show which reference to retrieve. The 
default when build is NULL is to use the build from the current ChipInfo annotation}

\item{dir}{character, 'dir' is the location to download cyto annotation information; if left as
NULL, depending on the value of getOption("save.annot.in.current"), the annotation will either
be saved in the working directory to speed-up subsequent lookups, or deleted after use.}

\item{...}{further arguments to Band.gene if entering gene names, or further arguments to 
Band.pos if entering ranges, or chr, pos/start/end}
}
\value{
Returns a vector of bands, if any entries span more than one band, the bands will be
concatenated as character type, delimited by semicolons (;)
}
\description{
Allows retrieval of the the cytoband/karyotype label, based on multiple
 possible input featues, including SNP chip or rs-ids, HGNC gene labels, GRanges or
 RangedData object, chromosome and position vectors. The most robust way to use the
 function is to use the parameter names to imply the type of input, e.g, use the 'genes'
 parameter to input gene labels, the 'snps' parameter to enter SNP ids, etc. However,
 if you enter the first argument as a GRanges or RangedData object instead of using the
 'ranges' argument, this will be detected and automatically moved to the 'ranges' parameter.
}
\examples{
\donttest{
setwd(tempdir())
Band(chr=1,pos=1234567) # using chr,pos vectors
rd <- RangedData(ranges=IRanges(start=87654321,end=87654321),space=1)
gr <- as(rd,"GRanges")
Band(rd)    # using RangedData, autodetects this parameter should be 'ranges' not 'genes'
Band(ranges=gr) # using GRanges
Band("SLC6A4")  # serotonin gene [5-HTT]
a.few.snps <- c("rs3842724","imm_11_2147527","rs9467354")
Band(a.few.snps) # using SNP ids in the 'genes' parameter (still works!)
Band(snps=a.few.snps) # using SNP ids with the dedicated 'snps' parameter is quicker
Band(chr="X",pos=8000000)
# Band() with longer ranges  #
Band(chr=12,start=40000000,end=50000000,build="hg19") # concatenates if range spans multiple bands
Band(chr=12,start=40000000,end=50000000,build="hg18") # one extra band in the older annotation
}
}
\seealso{
\code{\link{Chr}}, \code{\link{Pos}}, \code{\link{Pos.gene}}, \code{\link{Band}}, 
\code{\link{Band.gene}}, \code{\link{Band.pos}}, \code{\link{Gene.pos}}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
