% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_exposure.R
\name{county_distance}
\alias{county_distance}
\title{Hurricane exposure by distance for counties}
\usage{
county_distance(counties, start_year, end_year, dist_limit)
}
\arguments{
\item{counties}{Character vector of the five-digit Federal Information
Processing Standard (FIPS) codes for counties for which the user wants to
determine storm exposure.}

\item{start_year}{Four-digit integer with first year to consider.}

\item{end_year}{Four-digit integer with last year to consider.}

\item{dist_limit}{Maximum distance, in kilometers, of how close the storm
track must come to the county's population mean center to classify
the county as "exposed" to the storm.}
}
\value{
Returns a dataframe with a row for each county-storm
   pair and with columns for:
   \itemize{
     \item{\code{storm_id}: }{Unique storm identifier with the storm name and year,
                 separated by a hyphen(e.g., "Alberto-1988",
                 "Katrina-2005")}
     \item{\code{fips}: }{County's 5-digit Federal Information Processing Standard
                 (FIPS) code}
     \item{\code{closest_date}: }{Date (based on local time) of the closest
                         approach of the storm to the county's population
                         mean center.}
     \item{\code{storm_dist}: }{Minimum distance (in kilometers) between the storm's
                    track and the county's population mean center.}
     \item{\code{local_time}: }{Local time of the closest approach of the storm to the
                       county's population mean center, based on storm tracks
                       linearly interpolated to 15-minute increments.}
    \item{\code{closest_time_utc}: }{Time, in UTC, of the closest approach of the
                            storm to the county's population mean center,
                            based on storm tracks linearly interpolated to
                            15-minute increments.}
   }
}
\description{
This function takes a list of US counties,based on their 5-digit Federal
Information Processing Standard (FIPS) codes, boundaries on
the range of years to be considered, and thresholds for distance between each
county and the storm track for the county to be considered "exposed" to the
storm. Based on these inputs, the function returns a dataframe with the
subset of Atlantic basin storms meeting those criteria for each of the listed
counties.
}
\details{
For more information on how distances between counties and storm
   tracks are calculated for this function, see the documentation for the
   \code{closest_dist} dataset that comes with this package.
}
\note{
Only counties in states in the eastern half of the United States can
   be processed by this function.
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

  county_distance(counties = c("22071", "51700"),
              start_year = 1995, end_year = 2005,
              dist_limit = 75)

}
}

