% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rain_exposure.R
\name{multi_county_rain}
\alias{multi_county_rain}
\title{Hurricane exposure by rain for communities}
\usage{
multi_county_rain(communities, start_year, end_year, rain_limit, dist_limit,
  days_included = c(-2, -1, 0, 1))
}
\arguments{
\item{communities}{A dataframe with the FIPS codes for all counties within
each community. It must include columns with a column identifier
(\code{commun}) and with the FIPS codes of counties included in each
community (\code{fips}). See the example code.}

\item{start_year}{Four-digit integer with first year to consider.}

\item{end_year}{Four-digit integer with last year to consider.}

\item{rain_limit}{Minimum of rainfall, in millimeters, summed across the days
selected to be included (\code{days_included}), that must fall in a
county for the county to be classified as "exposed" to the storm.}

\item{dist_limit}{Maximum distance, in kilometers, of how close the storm
track must come to the county's population mean center to classify
the county as "exposed" to the storm.}

\item{days_included}{A numeric vector listing the days to include when
calculating total precipitation. Negative numbers are days before the
closest date of the storm to a county. For example,
\code{c(-1, 0, 1)} would calculate rain for a county as the sum of the
rainfall for the day before, the day of, and the day after the date when
the storm center was closest to the county center. Values can range from
-5 to 3 (i.e., at most, you can calculate the total rainfall from five days
to three days after the day when the storm is closest to the
county).}
}
\value{
Returns a dataframe with a row for each county-storm pair and with
   columns for:
   \itemize{
     \item{\code{commun}: }{Each community's unique id}
     \item{\code{storm_id}: }{Unique storm identifier with the storm name and year,
                 separated by a hyphen(e.g., "Alberto-1988",
                 "Katrina-2005")}
     \item{\code{closest_date}: }{Date (based on local time) of the closest
                         approach of the storm to the county's population
                         mean center.}
     \item{\code{local_time}: }{Local time of the closest approach of the storm to the
                       county's population mean center, based on storm tracks
                       linearly interpolated to 15-minute increments.}
    \item{\code{closest_time_utc}: }{Time, in UTC, of the closest approach of the
                            storm to the county's population mean center,
                            based on storm tracks linearly interpolated to
                            15-minute increments.}
     \item{\code{mean_dist}: }{Average of the minimum distance (in kilometers)
                               between the storm's track and the population
                               mean centers of all the counties in the
                               community.}
     \item{\code{mean_rain}: }{Average of cumulative rainfall, in millimeters,
                               in the counties in the community for the days
                               selected using the \code{days_included} option.}
    \item{\code{min_dist}: }{The smallest minimum distance (in kilometers)
                               between the storm's track and the population
                               mean centers of any of the counties in the
                               community.}
    \item{\code{max_rain}: }{The maximum cumulative rainfall, in millimeters,
                               in any of the counties in the community for
                               the days selected using the \code{days_included}
                               option.}
   }
}
\description{
This function takes a dataframe with multi-county communities (see example for
the proper format) and returns a community-level dataframe of storms to which
the community was exposed, based on the average distance
between the storm's track and the population-based centers of each county
in the community and the given threshold of rainfall, summed over the days
included in the rainfall measurement.
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

communities <- data.frame(commun = c(rep("ny", 6), "no", "new"),
                         fips = c("36005", "36047", "36061",
                                  "36085", "36081", "36119",
                                  "22071", "51700"))
rain_storm_df <- multi_county_rain(communities = communities,
                                   start_year = 1995, end_year = 2005,
                                   rain_limit = 100, dist_limit = 100)
}
}
\references{
Al-Hamdan MZ, Crosson WL, Economou SA, Estes MG, Estes SM, Hemmings SN,
Kent ST, Puckette M, Quattrochi DA, Rickman DL, Wade GM, McClure LA, 2014.
Environmental public health applications using remotely sensed data.
Geocarto International 29(1):85-98.

North America Land Data Assimilation System (NLDAS) Daily Precipitation
years 1979-2011 on CDC WONDER Online Database, released 2012.
\url{http://wonder.cdc.gov/wonder/help/Precipitation.html}

Rui H, Mocko D, 2014. README Document for North America Land Data
Assimilation System Phase 2 (NLDAS-2) Products. Goddard Earth Sciences
Data and Information Services Center.
}

