% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{themes}
\alias{themes}
\alias{theme_minimal}
\alias{theme_striped}
\alias{theme_article}
\title{Theme a Huxtable}
\usage{
theme_minimal(ht, header_row = TRUE, header_col = TRUE)

theme_striped(ht, stripe = grey(0.9), header_row = TRUE,
  header_col = TRUE)

theme_article(ht, header_row = TRUE, header_col = TRUE)
}
\arguments{
\item{ht}{A huxtable object.}

\item{header_row}{Logical: style first row differently?}

\item{header_col}{Logical: style first column differently?}

\item{stripe}{Background colour for alternate rows}
}
\value{
The huxtable object, appropriately styled.
}
\description{
These functions quickly set default styles for a huxtable.
}
\details{
\code{theme_minimal} is a minimal theme with a simple line under headers.

\code{theme_striped} uses different backgrounds for alternate rows, and for headers.

\code{theme_article} is similar to the style of many scientific journals.
It sets horizontal lines above and below the table.
}
\examples{
ht <- huxtable(a = 1:5, b = 1:5)
theme_striped(ht)
}
