% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{latex_float}
\alias{latex_float}
\alias{latex_float<-}
\alias{set_latex_float}
\title{Float position for LaTeX}
\usage{
latex_float(ht)
latex_float(ht) <- value
set_latex_float(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A length-one character vector, used by LaTeX for positioning the float. Set to \code{NA} to reset to the default, which is
\code{"h"}.}
}
\value{
For \code{latex_float}, the \code{latex_float} property.
For \code{set_latex_float}, the \code{ht} object.
}
\description{
Functions to get or set the table-level \emph{float position for latex} property of a huxtable.
}
\details{
Quick reference: 'h' here, 'h!' definitely here, 't' top of page, 'b' bottom of page, 'p' page of
floats. See LaTeX documentation for more details. If you use 'H' (definitely here), you must require the
TeX \code{float} package.
}
\examples{

ht <- huxtable(a = 1:3, b = 1:3)
latex_float(ht) <-  'h'
latex_float(ht)

}
