% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flood3.R
\name{flood3}
\alias{flood3}
\title{Function to compute flood extent or flood duration \code{SpatRaster}
along the German federal waterways Elbe and Rhine using the 1d water level
algorithms \code{hyd1d::waterLevel()} and \code{hyd1d::waterLevelPegelonline()}}
\usage{
flood3(x, seq, filename = "", ...)
}
\arguments{
\item{x}{has to by type \code{SpatRaster} and has to include both input
raster layers \code{csa} (cross section areas) and \code{dem} (digital
elevation model). To compute water levels along the River Elbe \code{x}
has to be in the coordinate reference system
\href{https://spatialreference.org/ref/epsg/etrs89-utm-zone-33n/}{ETRS 1989 UTM 33N},
for River Rhine in
\href{https://spatialreference.org/ref/epsg/etrs89-utm-zone-32n/}{ETRS 1989 UTM 32N}.
Other coordinate reference systems are not permitted.}

\item{seq}{has to be type \code{c("POSIXct", "POSIXt")} or \code{Date} and
have a length larger than 0. If \code{seq} is type \code{c("POSIXct", "POSIXt")},
values must be in the temporal range between 31 days ago (\code{Sys.time() 
  - 2678400}) and now (\code{Sys.time()}). Then
\code{\link[hyd1d]{waterLevelPegelonline}} is used internally for the water
level computations. If \code{seq} is type \code{Date}, values must be in the
temporal range between 1960-01-01 and yesterday (\code{Sys.Date() - 1})
and \code{\link[hyd1d]{waterLevel}} is used internally.}

\item{filename}{supplies an optional output filename and has to be type
\code{character}.}

\item{\dots}{additional arguments as for \code{\link[terra]{writeRaster}}.}
}
\value{
\code{SpatRaster} object with flood duration in the range of
\code{[0, length(seq)]}.
}
\description{
Computes flood extent, if \code{length(seq)} equals 1, or flood
duration for the active floodplains along the German federal waterways Elbe
and Rhine based on 1d water levels computed by
\code{\link[hyd1d]{waterLevel}} or
\code{\link[hyd1d]{waterLevelPegelonline}} provided by package \pkg{hyd1d}.
}
\details{
For every time step provided in \code{seq}, \code{flood3()} computes
a 1d water level along the requested river section. This 1d water level is
transfered to a \code{wl} (water level) raster layer, which is in fact a
copy of the \code{csa} (cross section areas) layer, and then
compared to the \code{dem} (digital elevation model) layer. Where the
\code{wl} layer is higher than the \code{dem}, layer flood duration is
increased by 1.
}
\examples{
\donttest{
  options("hydflood.datadir" = tempdir())
  library(hydflood)
  
  # import the raster data and create a raster stack
  c <- st_crs("EPSG:25833")
  e <- ext(309000, 310000, 5749000, 5750000)
  x <- hydSpatRaster(ext = e, crs = c)
  
  # create a temporal sequence
  seq <- seq(as.Date("2016-12-01"), as.Date("2016-12-31"), by = "day")
  
  # compute a flood duration
  fd <- flood3(x = x, seq = seq)
}

}
\references{
\insertRef{weber_flood3data_2022}{hydflood}

\insertRef{weber_flood3data_2023}{hydflood}
}
\seealso{
\code{\link[hyd1d]{waterLevel}},
\code{\link[hyd1d]{waterLevelPegelonline}},
\code{\link[terra]{writeRaster}},
\code{\link[terra]{terraOptions}}
}
