% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_properties.R
\name{waterprops}
\alias{waterprops}
\alias{dvisc}
\alias{dens}
\alias{kvisc}
\title{Functions to calculate water properties: density, dynamic and kinematic viscosity}
\usage{
dvisc(T = NULL, units = c("SI", "Eng"))

dens(T = NULL, units = c("SI", "Eng"))

kvisc(T = NULL, units = c("SI", "Eng"))
}
\arguments{
\item{T}{numeric vector that contains the water temperature [C or F]}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units. This is used for compatibility with iemisc package}
}
\value{
rho, the density of water for the
  dens function [kg/m3 or slug/ft3].

mu, the dynamic viscosity of water for the
  dvisc function [Pa-s (N s m^-2) or lbf s ft^-2].

nu, the kinematic viscosity of water for the
  kvisc function [m2 s^-1 or ft^2 s^-1].
}
\description{
This function calculates the Darcy-Weisbach friction factor
and is only provided in this package for use with water in circular pipes
while the equation is technically valid for any liquid.
As with many parts of this package, techniques and formatting
were drawn from Irucka Embry's iemisc package, which includes some
methods with similar functionality.
function(ks,V,D,nu)
}
\examples{

#Find kinematic viscocity for water temperature of 55 F
nu = kvisc(T = 55, units = 'Eng')

#Find kinematic viscocity assuming default water temperature of 68 F
nu = kvisc(units = 'Eng')

#Find water density for water temperature of 25 C
rho = dens(T = 25, units = 'SI')

}
\author{
Ed Maurer
}
