% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_points_to_lines.R
\name{index_points_to_waterbodies}
\alias{index_points_to_waterbodies}
\title{Index Points to Waterbodies}
\usage{
index_points_to_waterbodies(
  waterbodies,
  points,
  flines = NULL,
  search_radius = NULL
)
}
\arguments{
\item{waterbodies}{sf data.frame of type POLYGON or MULTIPOLYGON including
a "wbid" attribute.}

\item{points}{sfc of type POINT}

\item{flines}{sf data.frame (optional) of type LINESTRING or MULTILINESTRING including
id, wbid, and topo_sort attributes. If omitted, only waterbody indexes are returned.}

\item{search_radius}{units class with a numeric value indicating how far to
search for a waterbody boundary in units of provided projection. Set units with
\link[units]{set_units}.}
}
\value{
data.frame with columns, \code{COMID}, \code{in_wb_COMID}, \code{near_wb_COMID},
\code{near_wb_dist}, and \code{outlet_fline_COMID}.
Distance is in units of provided projection.
}
\description{
given an sf point geometry column, return waterbody id, and
COMID of dominant artificial path
}
\examples{

source(system.file("extdata/sample_data.R", package = "nhdplusTools"))

waterbodies <- sf::st_transform(
  sf::read_sf(sample_data, "NHDWaterbody"), 5070)

points <- sf::st_transform(
  sf::st_sfc(sf::st_point(c(-89.356086, 43.079943)),
             crs = 4326), 5070)

index_points_to_waterbodies(waterbodies, points,
                    search_radius = units::set_units(500, "m"))

}
