% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydroscoper_package.R
\docType{package}
\name{hydroscoper}
\alias{hydroscoper}
\alias{_PACKAGE}
\alias{hydroscoper-package}
\title{hydroscoper: Interface to Hydroscope}
\description{
\code{hydroscoper} provides an R interface to the  Greek
National Data Bank for Hydrological and Meteorological Information
\code{http://www.hydroscope.gr}.

\code{hydroscoper} covers Hydroscope's data sources using the
\code{Enhydris API} and provides functions to:
\enumerate{
  \item {Transform the available tables and data sets into
       \href{https://tibble.tidyverse.org/}{tibbles}.}
  \item{Transliterate the Greek Unicode names to Latin.}
  \item{Translate various Greek terms to English.}
}
}
\section{Enhydris API}{


The Enhydris database is implemented in PostgreSQL. Details
can be found \href{https://enhydris.readthedocs.io}{here}
}

\section{Data Sources}{


The data are retrieved from the Hydroscope's databases:
\itemize{
  \item Ministry of Environment, Energy and Climate Change.
  \item Ministry of Rural Development and Food.
  \item  National Meteorological Service.
  \item  Greek Public Power Corporation.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ropensci/hydroscoper}
  \item \url{https://docs.ropensci.org/hydroscoper/}
  \item Report bugs at \url{https://github.com/ropensci/hydroscoper/issues}
}

}
\author{
\strong{Maintainer}: Konstantinos Vantas \email{kon.vantas@gmail.com} (\href{https://orcid.org/0000-0001-6387-8791}{ORCID})

Other contributors:
\itemize{
  \item Sharla Gelfand (Sharla Gelfand reviewed the package for rOpenSci, see https://github.com/ropensci/onboarding/issues/185) [contributor, reviewer]
  \item Tim Trice (Tim Trice reviewed the package for rOpenSci, see https://github.com/ropensci/onboarding/issues/185) [reviewer]
}

}
