% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qplot.R
\name{qplotc}
\alias{qplotc}
\title{Spectra plotting with ggplot2}
\usage{
qplotc(
  object,
  mapping = aes_string(x = "c", y = "spc"),
  ...,
  func = NULL,
  func.args = list(),
  map.pointonly = FALSE
)
}
\arguments{
\item{object}{hyperSpec object}

\item{mapping}{see  \code{\link[ggplot2]{geom_point}}}

\item{...}{handed to \code{\link[ggplot2]{geom_point}}}

\item{func}{function to summarize the wavelengths, if \code{NULL}, only the first wavelength is used}

\item{func.args}{arguments to \code{func}}

\item{map.pointonly}{if \code{TRUE}, \code{mapping} will be handed to
\code{\link[ggplot2]{geom_point}} instead of \code{\link[ggplot2]{ggplot}}.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object
}
\description{
Spectra plotting with ggplot2
}
\details{
These functions are still experimental and may change substantially in future.
}
\examples{
qplotc (flu)
qplotc (flu) + geom_smooth (method = "lm")
}
\seealso{
\code{\link{plotc}}

\code{\link[ggplot2]{ggplot}}\code{\link[ggplot2]{geom_point}}
}
\author{
Claudia Beleites
}
