% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperbolicDEA.R
\name{hyperbolicDEA}
\alias{hyperbolicDEA}
\title{Hyperbolic estimation of DEA efficiency scores}
\usage{
hyperbolicDEA(
  X,
  Y,
  RTS = "vrs",
  WR = NULL,
  SLACK = FALSE,
  ACCURACY = 1e-10,
  XREF = NULL,
  YREF = NULL,
  SUPEREFF = FALSE,
  NONDISC_IN = NULL,
  NONDISC_OUT = NULL,
  PARALLEL = 1,
  ALPHA = 0.5
)
}
\arguments{
\item{X}{Matrix or dataframe with DMUS as rows and inputs as columns}

\item{Y}{Matrix or dataframe with DMUs as rows and outputs as columns}

\item{RTS}{Character string indicating the returns-to-scale, e.g. "crs", "vrs", "ndrs", "nirs", "fdh"}

\item{WR}{Matrix with one row per homogeneous linear weight restriction in standard form, ncol(WR) = ncol(X) + ncol(Y)}

\item{SLACK}{Variable indicating whether an additional estimation of slacks shall be performed}

\item{ACCURACY}{Accuracy value for non-linear programmer}

\item{XREF}{Matrix or dataframe with firms defining the technology as rows and inputs as columns}

\item{YREF}{Matrix or dataframe with firms defining the technology as rows and outputs as columns}

\item{SUPEREFF}{Variable indicating whether super-efficiencies shall be estimated}

\item{NONDISC_IN}{Vector containing indices of the input matrix that are non-discretionary variables}

\item{NONDISC_OUT}{Vector containing indices of the output matrix that are non-discretionary variables}

\item{PARALLEL}{Integer of amount of cores that should be used for estimation (Check availability of computer)}

\item{ALPHA}{ALPHA can be chosen between [0,1]. It indicates the relative weights given to the distance function to
both outputs and inputs when approaching the frontier. More weight on the input orientation is set by alpha < 0.5. Here,
the input efficiency score is estimated in the package. To receive the corresponding output efficiency score, estimate: e^((1-alpha)/alpha).
Vice versa for an output weighted model alpha > 0.5. The output efficiency is given and the input efficiency can
be recovered with: e^(alpha/(1-alpha))}
}
\value{
A list object containing efficiency scores, lambdas, and potentially slacks and
binding parameters in the weight restrictions (mus)
}
\description{
Hyperbolic DEA implementation including weight restrictions,
non-discretionary variables, gerenralized distance function, external referencing, estimation of slacks and
super-efficiency scores. The mathematical and theoretical foundations of the code are presented in the paper
"Data Envelopment Analysis and Hyperbolic Efficiency Measures: Extending Applications and Possiblities
for Between-Group Comparisons" (2023) by Alexander Öttl, Mette Asmild, and Daniel Gulde.
}
\examples{
X <- c(1,1,2,4,1.5,2,4,3)
Y <- c(1,2,4,4,0.5,2.5,3.5,4)
hyperbolicDEA(X,Y,RTS="vrs", SUPEREFF = FALSE)

}
