% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\docType{methods}
\name{importance}
\alias{importance}
\alias{importance,Cube-method}
\title{Calculates the dimension importances of a given cube.}
\usage{
importance(x)
}
\arguments{
\item{x}{The \code{Cube} object for which the importance values will be computed.}
}
\value{
Sparsity value
}
\description{
Calculates the importance values for all dimensions of the actual view of a \code{Cube} object. All added selections and
aggregations will be regarded. Note that selection criteria will be applied before
aggregating the data.
}
\examples{

data("sales")
cube = generateCube(sales, columns = list(time = c("month", "year"),
      location = c("state"), product = "product"), valueColumn = "amount")
importance(cube)

}
\seealso{
\code{\link{sparsity}}
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
\keyword{methods}
