% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyphen.r
\name{hyphenate}
\alias{hyphenate}
\title{Hyphenate a character vector of words}
\usage{
hyphenate(words, simplify = TRUE)
}
\arguments{
\item{words}{character vector of words}

\item{simplify}{if \code{TRUE}, will return \code{words} with
\code{=} as the hyphen character. If \code{FALSE}, will
return a list of separated, hyphenated word components.
If a string (e.g. "\code{-}", "\code{&shy;}" or '\code{&#173;}")
will use that character for the hyphen character.)}
}
\value{
a character vector or a list depending on the value of
        \code{simplify}.
}
\description{
Given a character vector (one word per element), this function
will hyphenate the strings or return a list of separated
hyphenated string components.
}
\note{
The \code{en_US} hyphenation rules dictionary is loaded by default
}
\examples{
dat <- readLines(system.file("extdata/top10000en.txt", package="hyphenatr"))

out1 <- hyphenate(dat)
out2 <- hyphenate(dat, simplify=FALSE)
out3 <- hyphenate(dat, simplify="-")
out4 <- hyphenate(dat, simplify="&shy;")
}

