\name{hzar.make.fitRequest}
\alias{hzar.make.fitRequest}
\alias{hzar.fitRequest}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Generate a hzar.fitRequest with the specified attributes.
%%  ~~function to do ... ~~
}
\description{
  This method is meant to generate an arbitrary hzar.fitRequest object
  to pass to \code{\link{hzar.doFit}}. Note that this method does not
  check its arguments for validity. Use
  \code{\link{hzar.first.fitRequest.old.ML}} or
  \code{\link{hzar.next.fitRequest}} for a more convenient method for
  generating hzar.fitRequest objects.
}
\usage{
hzar.make.fitRequest(modelParameters, covMatrix, clineLLfunc, mcmcParameters, mcmcRaw = NULL, fit.run = FALSE, fit.success = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{modelParameters}{
    A named list of at least length 2. See details for format.
  }
  \item{covMatrix}{
    A covariance matrix for the gaussian proposal distribution as
    described in \code{\link{MCMCmetrop1R}}. Should
    be a square matrix of dimension equal to the number of free
    parameters, which can be generated by \code{\link{hzar.cov.rect}} or
    \code{\link{hzar.cov.mcmc}}. Although NULL is acceptable, it is
    extremely likely that hzar.doFit will crash.
  }
  \item{clineLLfunc}{
    A function of theta that returns a log likelihood.  It is best to
    use the results of
    \code{\link{hzar.make.clineLLfunc.old.ML}}, 
    \code{\link{hzar.make.clineLLfunc.old.bayes}}, or
    \code{\link{hzar.make.LLfunc.null}}.
  }
  \item{mcmcParameters}{
    The parameters controling the operation of the mcmc process.  Use
    the results from \code{\link{hzar.make.mcmcParam}}.
    %%     ~~Describe \code{mcmcParameters} here~~
  }
  \item{mcmcRaw}{
    The mcmc object created by a successful run of
    \code{\link{MCMCmetrop1R}}. Useful if you wish to import old mcmc
    objects for use with hzar.
  }
  \item{fit.run}{
    Has this particular request been run?  Note that this does not update
    automatically; the result of \code{\link{hzar.doFit}} is a new
    object with mcmcRaw, fit.run, and fit.success updated as
    appropriate. Primariy affects the behavior of
    \code{\link{hzar.next.fitRequest}}. 
    %%     ~~Describe \code{fit.run} here~~
  }
  \item{fit.success}{
    Has this particular request been run successfully?  Note that this
    does not update automatically; the result of
    \code{\link{hzar.doFit}} is a new object with mcmcRaw, fit.run, and
    fit.success updated as appropriate. Primariy affects the behavior of
    \code{\link{hzar.next.fitRequest}}.  
    %%     ~~Describe \code{fit.success} here~~
  }
}
\details{
  For modelParameters, the list must have the following entries:
  \itemize{
  \item{$init}{A named list with the initial values of the free
    parameters. Used as theta.init in \code{\link{MCMCmetrop1R}}.}
  \item{$tune}{A named list with the tuning values of the free
    parameters. Used as tune in \code{\link{MCMCmetrop1R}}.}
  }
  %%  ~~ If necessary, more details than the description above ~~
}
\value{
  A hzar.fitRequest object.
%%  ~Describe the value returned
%%  If it is a LIST, use
  A list with values:
  \item{$modelParam}{ modelParameters from above.}
  \item{$cM }{covMatrix from above.}
  \item{$llFunc}{clineLLfunc from above.}
  \item{$mcmcParam}{mcmcParameters from above.}
  \item{$mcmcRaw}{mcmcRaw from above.}
  and with attributes:
  \item{"fit.run"}{fit.run from above.}
  \item{"fit.success"}{fit.success from above.}
    
%% ...
}
% \references{
% %% ~put references to the literature/web site here ~
% }
\author{
  Graham Derryberry \email{asterion@alum.mit.edu}

}
\note{
  Although modelParameters only needs to contain $init and $tune, modelParam
  will sometimes contain $fixed, $lower and $upper.  These are artifacts
  of hzar.make.clineLLfunc.old.ML and can be safely ignored.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  \code{\link{hzar.first.fitRequest.old.ML}}
  \code{\link{hzar.next.fitRequest}}
  \code{\link{hzar.cov.mcmc}}
  \code{\link{hzar.cov.rect}}
  \code{\link{hzar.make.clineLLfunc.old.ML}}
  \code{\link{hzar.make.clineLLfunc.old.bayes}}
  \code{\link{hzar.make.LLfunc.null}}
  \code{\link{hzar.make.mcmcParam}}
  \code{\link{MCMCmetrop1R}}
}
% \examples{
% ##---- Should be DIRECTLY executable !! ----
% ##-- ==>  Define data, use random,
% ##--	or do  help(data=index)  for the standard data sets.

% ## The function is currently defined as
% function (modelParameters, covMatrix, clineLLfunc, mcmcParameters, 
%     mcmcRaw = NULL, fit.run = FALSE, fit.success = FALSE) 
% {
%     fitRequest <- list(modelParam = modelParameters, cM = covMatrix, 
%         llFunc = clineLLfunc, mcmcParam = mcmcParameters, mcmcRaw = mcmcRaw)
%     class(fitRequest) <- "hzar.fitRequest"
%     attr(fitRequest, "fit.run") <- fit.run
%     attr(fitRequest, "fit.success") <- fit.success
%     return(fitRequest)
%   }
% }
% % Add one or more standard keywords, see file 'KEYWORDS' in the
% % R documentation directory.
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
