% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_rolling_average.R
\name{add_rolling_average}
\alias{add_rolling_average}
\title{Add a rolling average}
\usage{
add_rolling_average(
  x,
  n = 3L,
  complete_dates = TRUE,
  align = c("right", "center"),
  colname = "rolling_average",
  ...
)
}
\arguments{
\item{x}{\verb{[incidence2]} object}

\item{n}{\verb{[integer]}

How many date groupings to consider in each window?

\code{double} vectors will be converted via \code{as.integer(n)}.}

\item{complete_dates}{\verb{[bool]}

Should \code{incidence2::complete_dates()} be called on the data prior to adding
the rolling average.

Defaults to TRUE.}

\item{align}{ character, define if rolling window covers preceding rows
    (\code{"right"}), following rows (\code{"left"}) or centered
    (\code{"center"}). Defaults to \code{"right"}. }

\item{colname}{\verb{[character]}

The name of the column to contain the rolling average.}

\item{...}{Other arguments passed to \code{incidence2::complete_dates()}}
}
\value{
The input object with an additional column for the rolling average.
}
\description{
\code{add_rolling_average()} adds a rolling average to an \verb{<incidence2>} object.
If multiple groupings or count variables are present then the average will be
calculated for each.
}
\examples{

if (requireNamespace("outbreaks", quietly = TRUE)) {
\dontshow{withAutoprint(\{}

  data(ebola_sim_clean, package = "outbreaks")
  dat <- ebola_sim_clean$linelist
  dat <- subset(dat, date_of_onset <= as.Date("2014-10-05"))

  inci <- incidence2::incidence(
      dat,
      date_index = "date_of_onset",
      groups = "gender",
      interval = "isoweek"
  )

  add_rolling_average(inci, n = 3L)
  inci2 <- incidence2::regroup(inci)
  add_rolling_average(inci2, n = 7L)
\dontshow{\})}
}

}
