% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIARfit.R
\name{BIAR.fit}
\alias{BIAR.fit}
\title{Fitted Values of BIAR model}
\usage{
BIAR.fit(x, y1, y2, t, yerr1, yerr2, zero.mean = "TRUE")
}
\arguments{
\item{x}{An array with the parameters of the BIAR model. The elements of the array are, in order, the autocorrelation and the cross correlation parameter of the BIAR model.}

\item{y1}{Array with the observations of the first time series of the BIAR process.}

\item{y2}{Array with the observations of the second time series of the BIAR process.}

\item{t}{Array with the irregular observational times.}

\item{yerr1}{Array with the measurements error standard deviations of the first time series of the BIAR process.}

\item{yerr2}{Array with the measurements error standard deviations of the second time series of the BIAR process.}

\item{zero.mean}{logical; if true, the array y has zero mean; if false, y has a mean different from zero.}
}
\value{
A list with the following components:
\itemize{
\item{rho}{ Estimated value of the contemporary correlation coefficient.}
\item{innov.var}{ Estimated value of the innovation variance.}
\item{fitted}{ Fitted values of the BIAR model.}
\item{fitted.state}{ Fitted state values of the BIAR model.}
}
}
\description{
Fit a BIAR model to a bivariate irregularly observed time series.
}
\examples{
\donttest{
n=80
set.seed(6714)
st<-gentime(n)
x=BIAR.sample(n=n,phi.R=0.9,phi.I=0.3,sT=st,rho=0.9)
y=x$y
y1=y/apply(y,1,sd)
yerr1=rep(0,n)
yerr2=rep(0,n)
biar=BIAR.kalman(y1=y1[1,],y2=y1[2,],t=st,delta1 = yerr1,delta2=yerr2)
biar
predbiar=BIAR.fit(x=c(biar$phiR,biar$phiI),y1=y1[1,],y2=y1[2,],t=st,yerr1
 = rep(0,length(y[1,])),yerr2=rep(0,length(y[1,])))
rho=predbiar$rho
print(rho)
yhat=predbiar$fitted
}
}
\seealso{
\code{\link{gentime}}, \code{\link{BIAR.sample}}, \code{\link{BIAR.phi.kalman}}, \code{\link{BIAR.kalman}}
}
