% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F042vdj.stats.R
\name{vdj.stats}
\alias{vdj.stats}
\title{VDJ stats}
\usage{
vdj.stats(my.vdj = "data.frame")
}
\arguments{
\item{my.vdj}{A data frame containing VDJ data for cells.}
}
\value{
An object of class iCellR
}
\description{
This function takes a data frame of VDJ info per cell and dose QC.
}
\examples{
my.vdj <- read.csv(file = system.file('extdata', 'all_contig_annotations.csv',
          package = 'iCellR'),
          as.is = TRUE)
head(my.vdj)
dim(my.vdj)

My.VDJ <- prep.vdj(vdj.data = my.vdj, cond.name = "NULL")
head(My.VDJ)
dim(My.VDJ)

vdj.stats(My.VDJ)

}
