% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F0065.R
\name{run.anchor}
\alias{run.anchor}
\title{Run anchor alignment on the main data.}
\usage{
run.anchor(
  x = NULL,
  method = "base.mean.rank",
  top.rank = 500,
  gene.list = "character",
  data.type = "main",
  normalization.method = "LogNormalize",
  scale.factor = 10000,
  margin = 1,
  block.size = NULL,
  selection.method = "vst",
  nfeatures = 2000,
  anchor.features = 2000,
  scale = TRUE,
  sct.clip.range = NULL,
  reduction = c("cca", "rpca"),
  l2.norm = TRUE,
  dims = 1:30,
  k.anchor = 5,
  k.filter = 200,
  k.score = 30,
  max.features = 200,
  nn.method = "rann",
  eps = 0,
  k.weight = 100
)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{method}{Choose from "base.mean.rank" or "gene.model", default is "base.mean.rank". If gene.model is chosen you need to provide gene.list.}

\item{top.rank}{A number taking the top genes ranked by base mean, default = 500.}

\item{gene.list}{A charactor vector of genes to be used for PCA. If "clust.method" is set to "gene.model", default = "my_model_genes.txt".}

\item{data.type}{Choose from "main" and "imputed", default = "main"}

\item{normalization.method}{Choose from "LogNormalize", "CLR" and "RC". LogNormalize: Feature counts for each cell are divided by the total counts for that cell and multiplied by the scale.factor. This is then natural-log transformed using log1p. CLR: Applies a centered log ratio transformation. RC: Relative counts. Feature counts for each cell are divided by the total counts for that cell and multiplied by the scale.factor. No log-transformation is applied. For counts per million (CPM) set ‘scale.factor = 1e6’}

\item{scale.factor}{Sets the scale factor for cell-level normalization.}

\item{margin}{If performing CLR normalization, normalize across features (1) or cells (2)}

\item{block.size}{How many cells should be run in each chunk, will try to split evenly across threads}

\item{selection.method}{Choose from "vst","mean.var.plot (mvp)","dispersion (disp)".}

\item{nfeatures}{Number of features to select as top variable features; only used when ‘selection.method’ is set to ‘'dispersion'’ or ‘'vst'’}

\item{anchor.features}{A numeric value. This will call ‘SelectIntegrationFeatures’ to select the provided number of features to be used in anchor finding}

\item{scale}{Whether or not to scale the features provided. Only set to FALSE if you have previously scaled the features you want to use for each object in the object.list}

\item{sct.clip.range}{Numeric of length two specifying the min and max values the Pearson residual will be clipped to}

\item{reduction}{cca: Canonical correlation analysis. rpca: Reciprocal PCA}

\item{l2.norm}{Perform L2 normalization on the CCA cell embeddings after dimensional reduction}

\item{dims}{Which dimensions to use from the CCA to specify the neighbor search space}

\item{k.anchor}{How many neighbors (k) to use when picking anchors}

\item{k.filter}{How many neighbors (k) to use when filtering anchors}

\item{k.score}{How many neighbors (k) to use when scoring anchors}

\item{max.features}{The maximum number of features to use when specifying the neighborhood search space in the anchor filtering}

\item{nn.method}{Method for nearest neighbor finding. Options include: rann, annoy}

\item{eps}{Error bound on the neighbor finding algorithm (from RANN)}

\item{k.weight}{Number of neighbors to consider when weighting}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and runs anchor alignment. It's a wrapper for Seurat.
}
