/*
 * Decompiled with CFR 0.152.
 */
package mrmc.chart;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import mrmc.chart.XYPair;

public class InterpolatedLine {
    private HashMap<XYPair, double[]> allLineEqs;
    private TreeSet<XYPair> actualPoints;

    public InterpolatedLine(TreeSet<XYPair> series) {
        TreeMap<Double, TreeSet> allDistinctXs = new TreeMap<Double, TreeSet>();
        for (XYPair point : series) {
            TreeSet ts;
            if (!allDistinctXs.containsKey(point.x)) {
                ts = new TreeSet();
                ts.add(point.y);
                allDistinctXs.put(point.x, ts);
                continue;
            }
            ts = (TreeSet)allDistinctXs.get(point.x);
            ts.add(point.y);
            allDistinctXs.put(point.x, ts);
        }
        this.actualPoints = new TreeSet();
        for (Double x : allDistinctXs.keySet()) {
            double allY = 0.0;
            int denom = 0;
            for (Double y : (TreeSet)allDistinctXs.get(x)) {
                allY += y.doubleValue();
                ++denom;
            }
            this.actualPoints.add(new XYPair(x, allY / (double)denom));
        }
        this.allLineEqs = new HashMap();
        Iterator<XYPair> iter = this.actualPoints.iterator();
        XYPair prev = iter.next();
        while (iter.hasNext()) {
            double[] eq;
            XYPair curr = iter.next();
            eq = new double[]{(prev.y - curr.y) / (prev.x - curr.x), prev.y - prev.x * eq[0]};
            this.allLineEqs.put(curr, eq);
            prev = curr;
        }
    }

    public double getYat(double x) {
        if (x > 1.0) {
            return 1.0;
        }
        if (x <= 0.0) {
            return 0.0;
        }
        XYPair currCeiling = this.actualPoints.ceiling(new XYPair(x, 0.0));
        double m = this.allLineEqs.get(currCeiling)[0];
        double b = this.allLineEqs.get(currCeiling)[1];
        return m * x + b;
    }

    public double getXat(double y) {
        if (y > 1.0) {
            return 1.0;
        }
        if (y <= 0.0) {
            return 0.0;
        }
        Iterator<XYPair> iter = this.actualPoints.iterator();
        XYPair currCeiling = null;
        XYPair prev = iter.next();
        while (iter.hasNext()) {
            XYPair curr = iter.next();
            if (y > prev.y && y < curr.y) {
                currCeiling = curr;
            }
            prev = curr;
        }
        if (currCeiling == null) {
            currCeiling = this.actualPoints.higher(this.actualPoints.first());
        }
        double m = this.allLineEqs.get(currCeiling)[0];
        double b = this.allLineEqs.get(currCeiling)[1];
        double returnX = (y - b) / m;
        if (returnX > 1.0) {
            return 1.0;
        }
        if (returnX < 0.0) {
            return 0.0;
        }
        return returnX;
    }

    public double getYatDiag(double x) {
        if (x > Math.sqrt(2.0)) {
            return 0.0;
        }
        if (x <= 0.0) {
            return 0.0;
        }
        XYPair currCeiling = this.actualPoints.ceiling(new XYPair(x, 0.0));
        double m = this.allLineEqs.get(currCeiling)[0];
        double b = this.allLineEqs.get(currCeiling)[1];
        return m * x + b;
    }
}

