/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.UniformDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class UniformGen
extends RandomVariateGen {
    private double a;
    private double b;

    public UniformGen(RandomStream s, double a, double b) {
        super(s, new UniformDist(a, b));
        this.setParams(a, b);
    }

    public UniformGen(RandomStream s) {
        this(s, 0.0, 1.0);
    }

    public UniformGen(RandomStream s, UniformDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getA(), dist.getB());
        }
    }

    public static double nextDouble(RandomStream s, double a, double b) {
        return UniformDist.inverseF(a, b, s.nextDouble());
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    private void setParams(double a, double b) {
        if (b <= a) {
            throw new IllegalArgumentException("b <= a");
        }
        this.a = a;
        this.b = b;
    }
}

