% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwr_mdn.R
\name{pwr.mdn}
\alias{pwr.mdn}
\title{Power and Sample Size for Mediation Analysis}
\usage{
pwr.mdn(a, b, c.p, tau1, tau2, n = NULL, power = NULL, alpha = 0.05)
}
\arguments{
\item{a}{specified value for coefficient \eqn{a}}

\item{b}{specified value for coefficient \eqn{b}}

\item{c.p}{specified value for coefficient \eqn{c'}}

\item{tau1}{specified value of the ratio of residual variance of mediator \eqn{M} to the variance of the treatment \eqn{X}}

\item{tau2}{specified value of the ratio of residual variance of outcome \eqn{Y} to the variance of the treatment \eqn{X}}

\item{n}{the sample size available. Either \code{"n"} or \code{"power"} must be provided}

\item{power}{a value specifying the desired power. Either \code{"n"} or \code{"power"} must be provided}

\item{alpha}{specified significance level}
}
\value{
A \eqn{2\times 5} matrix
}
\description{
\code{pwr.mdn} Compute power of tests related to mediation analysis or sample size to achieve desired power.
}
\details{
This model is for the basic three-factor model. If coefficients are standardized, then \eqn{\tau_1=1-a^2} and \eqn{\tau_2=1-(c')^2-b^2-2abc'}.
}
\examples{

n = 100
X = rnorm(n)
s2X = mean((X-mean(X))^2)
a=0.3
b=0.3
c.p = a*b

pwr.mdn(a, b, c.p, 1/s2X, 1/s2X, alpha=0.05, power=0.8)   
pwr.mdn(a, b, c.p, 1/s2X, 1/s2X, alpha=0.05, n=200)

## Using standardized coefficients
pwr.mdn(a, b, c.p, 1-a^2, 1-c.p^2-b^2-2*a*b*c.p, alpha=0.05, power=0.8)
pwr.mdn(a, b, c.p, 1-a^2, 1-c.p^2-b^2-2*a*b*c.p, alpha=0.05, n=200)

}
\references{
Wang, K. (2017) Understanding power anomalies in mediation analysis. Revision submitted.
}
\author{
Kai Wang \code{<kai-wang@uiowa.edu>}
}
\keyword{power}
