% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSummary.R
\name{getPlotSummary}
\alias{getPlotSummary}
\title{iNZight Plot Summary and Inference}
\usage{
getPlotSummary(
  x,
  y = NULL,
  g1 = NULL,
  g1.level = NULL,
  g2 = NULL,
  g2.level = NULL,
  varnames = list(),
  colby = NULL,
  sizeby = NULL,
  data = NULL,
  design = NULL,
  freq = NULL,
  missing.info = TRUE,
  inzpars = inzpar(),
  summary.type = "summary",
  hypothesis.value = 0,
  hypothesis.alt = c("two.sided", "less", "greater"),
  hypothesis.var.equal = FALSE,
  hypothesis.use.exact = FALSE,
  hypothesis.test = c("default", "t.test", "anova", "chi2", "proportion"),
  hypothesis.simulated.p.value = FALSE,
  hypothesis = list(value = hypothesis.value, alternative = match.arg(hypothesis.alt),
    var.equal = hypothesis.var.equal, use.exact = hypothesis.use.exact, test =
    match.arg(hypothesis.test), simulated.p.value = hypothesis.simulated.p.value),
  survey.options = list(),
  width = 100,
  epi.out = FALSE,
  ...,
  env = parent.frame()
)
}
\arguments{
\item{x}{a vector (numeric or factor), or the name of a column in the supplied
\code{data} or \code{design} object}

\item{y}{a vector (numeric or factor), or the name of a column in the supplied
\code{data} or \code{design} object}

\item{g1}{a vector (numeric or factor), or the name of a column in the supplied
\code{data} or \code{design} object. This variable acts as a subsetting variable.}

\item{g1.level}{the name (or numeric position) of the level of \code{g1} that will be
used instead of the entire data set}

\item{g2}{a vector (numeric or factor), or the name of a column in the supplied
\code{data} or \code{design} object. This variable acts as a subsetting variable, similar to
\code{g1}}

\item{g2.level}{same as \code{g1.level}, however takes the additional value \code{"_MULTI"},
which produces a matrix of \code{g1} by \code{g2}}

\item{varnames}{a list of variable names, with the list named using the appropriate arguments
(i.e., \code{list(x = "height", g1 = "gender")})}

\item{colby}{the name of a variable (numeric or factor) to colour points by. In the
case of a numeric variable, a continuous colour scale is used, otherwise each level of
the factor is assigned a colour}

\item{sizeby}{the name of a (numeric) variable, which controls the size of points}

\item{data}{the name of a data set}

\item{design}{the name of a survey object, obtained from the \code{survey} package}

\item{freq}{the name of a frequency variable if the data are frequencies}

\item{missing.info}{logical, if \code{TRUE}, information regarding missingness is
displayed in the plot}

\item{inzpars}{allows specification of iNZight plotting parameters over multiple plots}

\item{summary.type}{one of \code{"summary"} or \code{"inference"}}

\item{hypothesis.value}{H0 value for hypothesis test}

\item{hypothesis.alt}{alternative hypothesis (!=, <, >)}

\item{hypothesis.var.equal}{use equal variance assumption for t-test?}

\item{hypothesis.use.exact}{logical, if \code{TRUE} the exact p-value will be calculated (if applicable)}

\item{hypothesis.test}{in some cases (currently just two-samples) can perform multiple tests (t-test or ANOVA)}

\item{hypothesis.simulated.p.value}{also calculate (where available) the simulated p-value}

\item{hypothesis}{either NULL for no test, or missing (in which case above arguments are used)}

\item{survey.options}{additional options passed to survey methods}

\item{width}{width for the output, default is 100 characters}

\item{epi.out}{logical, if \code{TRUE}, then odds/rate ratios and rate differences are printed when appropriate (\code{y} with 2 levels)}

\item{...}{additional arguments, see \code{inzpar}}

\item{env}{compatibility argument}
}
\value{
an \code{inzight.plotsummary} object with a print method
}
\description{
Generate summary or inference information for an iNZight plot
}
\details{
Works much the same as \code{iNZightPlot}
}
\examples{
getPlotSummary(Species, data = iris)
getPlotSummary(Species, data = iris,
    summary.type = "inference", inference.type = "conf")

# perform hypothesis testing
getPlotSummary(Sepal.Length, data = iris,
    summary.type = "inference", inference.type = "conf",
    hypothesis.value = 5)

# if you prefer a formula interface
inzsummary(Sepal.Length ~ Species, data = iris)
inzinference(Sepal.Length ~ Species, data = iris)
}
\author{
Tom Elliott
}
