% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/iRafNet.R
\name{roc_curve}
\alias{roc_curve}
\title{Plot receiver operating characteristic (ROC) curve for weighted network generated by iRafNet}
\usage{
roc_curve(out, truth)
}
\arguments{
\item{out}{Output from iRafNet.}

\item{truth}{Matrix of true regulations. Rows correspond to different regulations and match rows of \code{out}. First column contains name of regulators, second column contains name of targets and third column contains a binary variable equal 1 in case of regulation and 0 otherwise.}
}
\value{
Plot ROC curve and return area under ROC curve.
}
\description{
This function uses R package ROCR to plot ROC curves for iRafNet object. }
\examples{

  # --- Generate data sets
  n<-20                  # sample size
  p<-5                   # number of genes
  genes.name<-paste("G",seq(1,p),sep="")   # genes name
  data<-matrix(rnorm(p*n),n,p)    # generate expression matrix
  data[,1]<-data[,2]              # var 1 and 2 interact
  W<-abs(matrix(rnorm(p*p),p,p))  # generate score for regulatory relationships
 
  # --- Standardize variables to mean 0 and variance 1
  data <- (apply(data, 2, function(x) { (x - mean(x)) / sd(x) } ))

  # --- Run iRafNet and obtain importance score of regulatory relationships
  out<-iRafNet(data,W,mtry=round(sqrt(p-1)),ntree=1000,genes.name)
  
  # --- Matrix of true regulations
  truth<-out[,seq(1,2)]
  truth<-cbind(as.character(truth[,1]),as.character(truth[,2])
  ,as.data.frame(rep(0,,dim(out)[1])));
  truth[(truth[,1]=="G2" & truth[,2]=="G1") | (truth[,1]=="G1" & truth[,2]=="G2"),3]<-1 

  # --- Plot ROC curve and compute AUC
  auc<-roc_curve(out,truth)

}
\references{
Petralia, F., Wang, P., Yang, J., Tu, Z. (2015) Integrative random forest for gene regulatory network inference, \emph{Bioinformatics}, \bold{31}, i197-i205.

Sing, Tobias, et al. (2005) ROCR: visualizing classifier performance in R, \emph{Bioinformatics}, \bold{21}, 3940-3941.
}
