% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.spca.R
\name{meta.spca}
\alias{meta.spca}
\title{Meta-analytic sparse principal component analysis method in integrative study}
\usage{
meta.spca(x, L, mu1, eps = 1e-04, scale.x = TRUE, maxstep = 50,
  trace = FALSE)
}
\arguments{
\item{x}{list of data matrices, L datasets of explanatory variables.}

\item{L}{numeric, number of datasets.}

\item{mu1}{numeric, sparsity penalty parameter.}

\item{eps}{numeric, the threshold at which the algorithm terminates.}

\item{scale.x}{character, "TRUE" or "FALSE", whether or not to scale the variables x. The default is TRUE.}

\item{maxstep}{numeric, maximum iteration steps. The default value is 50.}

\item{trace}{character, "TRUE" or "FALSE". If TRUE, prints out its screening results of variables.}
}
\value{
A 'meta.spca' object that contains the list of the following items.
\itemize{
\item{x:}{ list of data matrices, L datasets of explanatory variables with centered columns. If scale.x is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{eigenvalue:}{ the estimated first eigenvalue.}
\item{eigenvector:}{ the estimated first eigenvector.}
\item{component:}{ the estimated first component.}
\item{variable:}{ the screening results of variables.}
\item{meanx:}{ list of numeric vectors, column mean of the original datasets x.}
\item{normx:}{ list of numeric vectors, column standard deviation of the original datasets x.}
}
}
\description{
This function provides penalty-based sparse principal component meta-analytic method to handle the multiple datasets with high dimensions generated under similar protocols, which is based on the principle of maximizing the summary statistics S.
}
\examples{
library(iSFun)
data("simData.pca")
x <- simData.pca$x
L <- length(x)

res <- meta.spca(x = x, L = L, mu1 = 0.5, trace = TRUE)
}
\references{
\itemize{
\item{Kim S H, Kang D, Huo Z, et al. Meta-analytic principal component analysis in integrative omics application[J]. Bioinformatics, 2018, 34(8): 1321-1328.}
}
}
\seealso{
See Also as \code{\link{ispca}}.
}
