% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICA.R
\name{ICA}
\alias{ICA}
\title{Independent Component Analysis
The input data is assumed to be a matrix.
ICA decomposes the matrix and extract the components that
are statistically independent each other.}
\usage{
ICA(
  X,
  J,
  algorithm = c("FastICA", "InfoMax", "ExtInfoMax"),
  num.iter = 100,
  thr = 1e-10,
  nonlinear_func = c("tanh", "exp", "kurtosis"),
  learning_rate = 1,
  verbose = FALSE
)
}
\arguments{
\item{X}{A matrix}

\item{J}{Rank parameter to decompose}

\item{algorithm}{The decomposition algorithm (Default: "FastICA")}

\item{num.iter}{The number of iteration}

\item{thr}{The threshold to terminate the iteration (Default: 1E-10)}

\item{nonlinear_func}{The function used in FastICA (Default: "tanh")}

\item{learning_rate}{The learning rate used in InfoMax or ExtInfoMax}

\item{verbose}{Verbose option}
}
\value{
A list containing the result of the decomposition
}
\description{
Independent Component Analysis
The input data is assumed to be a matrix.
ICA decomposes the matrix and extract the components that
are statistically independent each other.
}
\examples{
X <- matrix(runif(100*200), nrow=100, ncol=200)
J <- 5
out.FastICA <- ICA(X, J=J, algorithm="FastICA")
out.InfoMax <- ICA(X, J=J, algorithm="InfoMax")
out.ExtInfoMax <- ICA(X, J=J, algorithm="ExtInfoMax")
}
