% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/false_ring_proportion.R
\name{novak_freq}
\alias{novak_freq}
\title{iadf frequency per cambial age}
\usage{
novak_freq(iadf, po = NULL)
}
\arguments{
\item{iadf}{A data frame with numeric columns representing individual series
and years as rownames where years with IADF are marked binary with 1,
those without with 0, years not covered by the series are set to NA.}

\item{po}{a data frame with pith offsets with series names in the first and
pith offset as number of rings in the second column}
}
\value{
a data frame
}
\description{
Calculate the frequency per cambial age as suggested
 by Novak et al. (2013).
}
\examples{
data('example_iadf')
model <- novak_weibull(novak_freq(example_iadf), 15)
novak_index(example_iadf, model)
}
\references{
Novak, Klemen and Sánchez, Miguel Angel Saz and Čufar, Katarina and Raventós,
  Josep and de Luis, Martin, te and intra-annual density fluctuations in in Spain,
  IAWA Journal, 34, 459-474 (2013), DOI:https://doi.org/10.1163/22941932-00000037
  \url{http://booksandjournals.brillonline.com/content/journals/10.1163/22941932-00000037}.
}
\seealso{
\code{\link{novak_weibull}},
  \code{\link{novak_index}}
}
