% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{fit_cv}
\alias{fit_cv}
\title{fit_cv}
\usage{
fit_cv(grid, X, ...)
}
\arguments{
\item{grid}{The grid to fit.}

\item{X}{The features of the data.}

\item{...}{Other parameters, including zero or more target vectors as
required by the problem type. Refer to the Julia documentation for
available parameters.}
}
\description{
Fits a grid search to the training data with cross-validation
}
\details{
Julia Equivalent:
\href{https://docs.interpretable.ai/IAIBase/stable/reference/#IAI.fit_cv!}{\code{IAI.fit_cv!}}
}
\examples{
\donttest{
X <- iris[, 1:4]
y <- iris$Species
iai::iai_setup()
grid <- iai::grid_search(
    iai::optimal_tree_classifier(max_depth = 1),
)
iai::fit_cv(grid, X, y)
}
}
