% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{predict_hazard.glmnetcv_survival_learner}
\alias{predict_hazard.glmnetcv_survival_learner}
\title{Return the fitted hazard coefficient estimate made by a
\code{\link{glmnetcv_survival_learner}} for each point in the features.}
\usage{
\method{predict_hazard}{glmnetcv_survival_learner}(obj, X, fit_index = NULL, ...)
}
\arguments{
\item{obj}{The learner or grid to use for prediction.}

\item{X}{The features of the data.}

\item{fit_index}{The index of the fit in the path to use for prediction,
defaulting to the best fit if not supplied.}

\item{...}{Additional arguments (unused)}
}
\description{
A higher hazard coefficient estimate corresponds to a smaller predicted
survival time.
}
\details{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.1.1/Heuristics/reference/#IAI.predict_hazard-Tuple\%7BGLMNetCVSurvivalLearner\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7B\%3C\%3AReal\%7D\%7D\%7D}{\code{IAI.predict_hazard}}
}
\section{IAI Compatibility}{

Requires IAI version 3.0 or higher.
}

\examples{
\dontrun{iai::predict_hazard(lnr, X)}

}
