% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Item-Fit.R
\name{item_restscore}
\alias{item_restscore}
\title{Item Restscore Association}
\usage{
item_restscore(object)
}
\arguments{
\item{object}{An object of class "Rm", a fitted Rasch model or partial
credit model using  the functions RM or PCM in package eRm, or an object of class "pcmodel",
 a fitted partial credit model using the function pcmodel in package psychotools.}
}
\value{
a matrix containing:
\item{observed}{observed gamma coefficients}
\item{expected}{expected gamma coefficients}
\item{se}{standard errors}
\item{pvalue}{p values (under normal distribution assumption)}
\item{sig}{significance stars: 0  " *** "  0.001  " ** "  0.01  " * "  0.05   " . "  0.1  " "  1}
}
\description{
The observed Gamma coefficient between the score of a single item and the total score of the remaining items
is compared with the corresponding expected Gamma coefficient under the Rasch model.
}
\examples{
rm.mod <- RM(amts[,4:13])
item_restscore(rm.mod)
}
\references{
Kreiner, S. (2011). A note on item-restscore association in Rasch models.
\emph{Applied Psychological Measurement}, 35, 557-561.
}
\author{
Marianne Mueller
}
