% Generated by roxygen2 (4.0.2): do not edit by hand
\name{PCR6}
\alias{PCR6}
\title{PCR6 rule}
\usage{
PCR6(MassIn, TabConflict)
}
\arguments{
\item{MassIn}{Matrix with \eqn{2^n} rows and \eqn{nb} columns. Parameter \eqn{n} is the number of classes (or the length of discernment frame) and \eqn{nb} is the number of experts.}

\item{TabConflict}{The conflict table, which can be got using the function \eqn{ConflictTable}}
}
\value{
Two parts:

\item{Mass}{matrix with \eqn{2^n} rows and  one column, the combined mass}
\item{conf}{a number, total conflict}
}
\description{
PCR6 combination rule
}
\examples{
## The conflict table for two experts in a discernment frame with three elements
TabConflict=ConflictTable(2^3,2)
m1=c(0,0.4, 0.1, 0.2, 0.2, 0, 0, 0.1);
m2=c(0,0.2, 0.3, 0.1, 0.1, 0, 0.2, 0.1);
PCR6(cbind(m1,m2),TabConflict)
}
\seealso{
\code{\link{ConflictTable}}, \code{\link{decisionDST}}
}

