% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_job_status.R
\name{get_job_status}
\alias{get_job_status}
\title{Get the Status of a Submitted Job}
\usage{
get_job_status(pod_number, session_access_token, desired_job_id)
}
\arguments{
\item{pod_number}{Pod number is the number in the URL, e.g.
engage1.silverpop.com.}

\item{session_access_token}{Access token obtained during this session.}

\item{desired_job_id}{Id for job for which you want the status.}
}
\value{
A vector with the session's access token.
}
\description{
Prior to attempting this you must authenticate and obtain an
access token, and then submit a call that is processed as a
job to retrieve from the Acoustic portal. The function used
to submit that job will provide the Job Id.
}
\examples{
\dontrun{
access_token <- acoustic_auth(org_client_id = "abc",
org_client_secret = "xyz",
my_refresh_token = "123")

job_id <- get_all_contacts(access_token)
get_job_status(1, access_token, "123456789")
}
}
