% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_functions.R
\name{GOF_check}
\alias{GOF_check}
\title{Goodness of fit for GLMM}
\usage{
GOF_check(x, nsim = 100)
}
\arguments{
\item{x}{An object of clas \emph{iccc}.}

\item{nsim}{Number of simulations to run. Default is set to 100.}
}
\value{
An object of class \emph{GOF}. A list with the following components:
\itemize{
\item \emph{plot_env}. Plot of RQR envelopes with the original RQR.
\item \emph{plot_var}. Plot of the simulated RQR dispersion.
\item \emph{plot_zi}. Plot of the count of zeros in the simulated datasets.
\item \emph{res_var}. Dispersion of RQR from the original sample. Proportion of simulated RQR dispersion that are greater than the original dispersion that can be interpreted as a simulated P-value to check the goodness of fit on dispersion.
\item \emph{pval_var}. Proportion of simulated RQR dispersion that are greater than the original dispersion that can be interpreted as a simulated P-value to check the goodness of fit on dispersion.
\item \emph{zero_count}. Count of zeros in the original sample.
\item \emph{pval_zi}. Proportion of simulated zero count that are greater than that of the original dsample. It can be interpreted as a simulated P-value to check the hypothesis of zero-inflation.
}
}
\description{
Assessment of goodness of fit for GLMM
}
\details{
Randomized quantile residuals are computed for the fitted model. Simulations based on the fitted model are generated
and the model is refitted to each simulated dataset. Envelopes for RQR are built as the minimum and maximum RQR from
the refitted models. Additionally, a test for dispersion and zero inflation are carried out by comparing the RQR dispersion and the
number of zeros from the original model and data to those from the refitted models and simulated data.
}
\examples{
\donttest{
# Poisson model. Repeatability setting.
iccpois<-icc_counts(EPP,y="Social",id="id")
GOF_check(iccpois)
# Zero-inflated Poisson model. Repeatability setting
icczip<-icc_counts(EPP,y="Social",id="id",fam="zip")
GOF_check(icczip)
}
}
