% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{icd_explain}
\alias{icd_explain}
\alias{icd_explain.default}
\alias{icd_explain.list}
\alias{icd_explain.icd9}
\alias{icd_explain.icd9cm}
\alias{icd_explain.icd10cm}
\alias{icd_explain.icd10}
\title{Explain ICD-9 and ICD-10 codes in English}
\usage{
icd_explain(...)

\method{icd_explain}{default}(x, short_code = icd_guess_short(x),
  condense = TRUE, brief = FALSE, warn = TRUE, ...)

\method{icd_explain}{list}(x, ...)

\method{icd_explain}{icd9}(...)

\method{icd_explain}{icd9cm}(x, short_code = icd_guess_short(x),
  condense = TRUE, brief = FALSE, warn = TRUE, ...)

\method{icd_explain}{icd10cm}(x, short_code = icd_guess_short(x),
  condense = TRUE, brief = FALSE, warn = TRUE, ...)

\method{icd_explain}{icd10}(x, short_code = icd_guess_short(x),
  condense = TRUE, brief = FALSE, warn = TRUE, ...)
}
\arguments{
\item{...}{arguments passed on to other functions}

\item{x}{vector or other structure of ICD codes to explain in human language}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{condense}{single logical value which indicates whether to condense the
given set of ICD-9 codes by replacing subsets of codes with 'parent' codes
which exactly encompass certain subsets. E.g. If all cholera diagnoses are
provided, only '001 - Cholera' needs to be displayed, not all sub-types.}

\item{brief}{single logical value, default is \code{FALSE}. If \code{TRUE},
the short description from the canonical CMS descriptions (included in
\code{data-raw}) will be used, otherwise the long description is used.}

\item{warn}{single logical value, default is \code{TRUE}, meaning that codes
which do not correspond to diagnoses, or to three-digit codes, will trigger
a warning.}
}
\value{
data frame, or list of data frames, with fields for ICD-9 code, name
  and description. There is no guarantee on the order of the returned
  descriptions. \code{icd_explain_table} is designed to provide results in a
  reliable order (when not condensing codes, at least).
}
\description{
Convert 'decimal' format (123.45 style) ICD-9 codes into the name and
description for human review there are official ICD9-CM data tables, not with
conversion to decimal notation, but to the textual format.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Explain ICD codes from a character vector, guessing
ICD version

\item \code{list}: Explain all ICD-9 codes in a list of vectors

\item \code{icd9}: explain character vector of ICD-9 codes.

\item \code{icd9cm}: explain character vector of ICD-9-CM codes

\item \code{icd10cm}: ICD-10-CM explanation, current a minimal implementation

\item \code{icd10}: ICD-10 explanation, falls back on ICD-10-CM until
ICD-10 WHO copyright workaround is available
}}

\examples{
# by default, just show parent code and ignore children (428.0 not shown
# because 428 is present):
icd_explain(icd9_map_ahrq$CHF[1:3])
# same without condensing the list. In this case, 428.0 is shown:
icd_explain(icd9_map_ahrq$CHF[1:3], brief = TRUE)
# The first three in the ICD-10 equivalent are a little different:
icd_explain(icd10_map_ahrq$CHF[1:3], brief = TRUE)
# nice to have magrittr, but not essential
library(magrittr, warn.conflicts = FALSE, quietly = TRUE)
icd_explain(icd9_map_ahrq$CHF[1:3] \%>\% icd_condense)
}
\keyword{internal}
