% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ValidNaWarnStop}
\alias{icd9ValidNaWarnStop}
\alias{icd9ValidNaWarnStopDecimal}
\alias{icd9ValidNaWarnStopMajor}
\alias{icd9ValidNaWarnStopShort}
\title{stop, warn, replace invalid with NA or continue}
\usage{
icd9ValidNaWarnStop(icd9, isShort, isMajor = FALSE,
  invalidAction = icd9InvalidActions)

icd9ValidNaWarnStopShort(icd9Short, invalidAction)

icd9ValidNaWarnStopDecimal(icd9Decimal, invalidAction)

icd9ValidNaWarnStopMajor(major, invalidAction)
}
\arguments{
\item{icd9}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{isShort}{single logical value which determines whether the ICD-9 code provided is in short (TRUE) or decimal (FALSE) form.}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}

\item{major}{character vector of 'major' part of ICD-9 codes, i.e. that part
which falls before the decimal point, in decimal notation. (In 5 digit
notation, the 'major' part is be the first three characters (with leading
zeroes), and includes V or E prefix. xyz}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}
}
\value{
icd9 codes, with invalid codes replaced by NA, if \code{invalidAction != "ignore"}
}
\description{
Switch based on \code{invalidAction}
If \code{major} is provided, then \code{isShort} is ignored.
}
\seealso{
Other ICD9 validation: \code{\link{icd9GetInvalidMappingDecimal}},
  \code{\link{icd9GetInvalidMappingShort}},
  \code{\link{icd9ValidMapping}},
  \code{\link{icd9ValidMappingDecimal}},
  \code{\link{icd9ValidMappingShort}};
  \code{\link{icd9ValidDecimal}},
  \code{\link{icd9ValidDecimalE}},
  \code{\link{icd9ValidDecimalN}},
  \code{\link{icd9ValidDecimalV}};
  \code{\link{icd9ValidMajor}},
  \code{\link{icd9ValidMajorE}},
  \code{\link{icd9ValidMajorN}},
  \code{\link{icd9ValidMajorV}};
  \code{\link{icd9ValidShort}},
  \code{\link{icd9ValidShortE}},
  \code{\link{icd9ValidShortN}},
  \code{\link{icd9ValidShortV}}; \code{\link{icd9Valid}};
  \code{\link{stopIfInvalidIcd9}},
  \code{\link{warnIfInvalidIcd9}}
}
\keyword{internal}

