% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/datadocs.R
\docType{data}
\name{elixComorbidNames}
\alias{ahrqComorbidNames}
\alias{ahrqComorbidNamesAbbrev}
\alias{ahrqComorbidNamesHtn}
\alias{ahrqComorbidNamesHtnAbbrev}
\alias{charlsonComorbidNames}
\alias{charlsonComorbidNamesAbbrev}
\alias{elixComorbidNames}
\alias{elixComorbidNamesAbbrev}
\alias{elixComorbidNamesHtn}
\alias{elixComorbidNamesHtnAbbrev}
\alias{quanElixComorbidNames}
\alias{quanElixComorbidNamesAbbrev}
\alias{quanElixComorbidNamesHtn}
\alias{quanElixComorbidNamesHtnAbbrev}
\title{Comorbidity names}
\format{list, with character/numeric code. 'Hypertension, uncomplicated' and
  'Hypertension, complicated' are labelled '6a' and '6b'. Diabetes, cancer,
  and metastasis are counted independently, as in the original paper, giving
  the original 30 groups. "01" to "30"}
\description{
These lists provide correctly sorted names of the comorbidities
  and their particular permutations in both full and abbreviated forms.

  In the Elixhauser derived mappings, uncomplicated and complicated
  hypertension are listed separately, but are always combined in the final
  analyses. Uncomplicated and complicated hypertension are list separately
  and as "Hypertension, combined." Abbrev suffix indicates a very short
  space-free description. Quan's version of Elixhauser is identical. AHRQ's
  update drops the arrythmia field. The naming convention is a root, e.g.
  \code{elixComorbid}, with neither/either/both suffixes \code{Htn} and
  \code{Abbrev}. The Charlson derived mappings do not include hypertension.
  Abbreviated comorbidity names are helpful for interactive work, whereas the
  full names might be prefered for plotting.
}
\keyword{datasets}

