% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/parse-comorbid.R
\name{parseQuanDeyoSas}
\alias{parseQuanDeyoSas}
\title{parse original SAS code defining Quan's update of Deyo comorbidities.}
\usage{
parseQuanDeyoSas(sasPath = NULL, condense = FALSE, save = FALSE,
  path = "data")
}
\arguments{
\item{sasPath}{single character string containing path or URL for some SAS
code. The source SAS code is stored in extdata or at the location specified
in URL. In development mode in \code{devtools}, this is actually
inst/extdata. This function is internal, since it is used to generate data
which ends up in the distributed package. However, the package user can
verify that the code creates the distributed R data. Also, changes to the
original SAS code can be used to regenerate the R data by the user, without
waiting for a package release.}

\item{condense}{logical whether to condense the result ranges to the minimal
set of parent ICD-9 codes which exactly define the list. Defaults to
\code{FALSE} so that the saved list will allow rapid look-up of codes
without further processing. Small memory versus time trade-off.}

\item{save}{logical whether to save the result in the source tree. Defaults
to \code{FALSE}.}

\item{path}{path to directory to save the data. This is typically the data
folder in the devleopment source tree. Defaults to \code{"~/icd9/data"}.
Could possibly avoid hard-coding path with devtools functions.}
}
\value{
invisibly returns the list of vectors, where a
  co-morbidity name is associated with a character vector of ICD-9 codes.
}
\description{
As with \code{parseAhrqSas}, this function reads SAS code, and
  in, a very limited way, extracts definitions. In this case the code uses
  LET statements, with strings or lists of strings. This saves and invisibly
  returns a list with names corresponding to the comorbidities and values as
  a vector of 'short' form (i.e. non-decimal) ICD9 codes. Unlike
  \code{parseAhrqSas}, there are no ranges defined, so this interpretation is
  simpler.

  With thanks to Dr. Quan, I have permission to distribute his SAS code.
  Previously, the SAS code would be downloaded from the University of
  Manitoba at
  \url{http://mchp-appserv.cpe.umanitoba.ca/concept/ICD9_E_Charlson.sas.txt}.
  There are structural differences between this version and the version
  directly from Dr. Quan, however, the parsing results in identical data.
}
\keyword{internal}

