% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ices_get_jwt.R, R/ices_request_jwt.R
\name{ices_get_jwt}
\alias{ices_get_jwt}
\alias{ices_post_jwt}
\alias{ices_patch_jwt}
\alias{ices_request_jwt}
\title{ices_request_jwt}
\usage{
ices_get_jwt(
  url,
  username = NULL,
  retry = TRUE,
  quiet = FALSE,
  verbose = FALSE,
  jwt = NULL
)

ices_post_jwt(
  url,
  body = list(),
  encode = "json",
  username = NULL,
  retry = TRUE,
  quiet = FALSE,
  verbose = FALSE,
  jwt = NULL
)

ices_patch_jwt(
  url,
  body = list(),
  encode = "json",
  username = NULL,
  retry = TRUE,
  quiet = FALSE,
  verbose = FALSE,
  jwt = NULL
)

ices_request_jwt(
  type = c("GET", "POST", "PATCH"),
  url,
  body = NULL,
  encode = c("multipart", "form", "json", "raw"),
  username = NULL,
  retry = TRUE,
  quiet = FALSE,
  verbose = FALSE,
  jwt = NULL
)
}
\arguments{
\item{url}{the url to make the request to}

\item{username}{the ices username to perform the request as,
Default: getOption("ices.username")}

\item{retry}{if initial request fails, should a retry be made, Default: TRUE}

\item{quiet}{suppress informative messages to the console}

\item{verbose}{should the http request return verbose output}

\item{jwt}{option to supply a token bypassing the ices_token() route, if "" no token is used}

\item{body}{optional body of request}

\item{encode}{If the body is a named list, how should it be encoded?}

\item{type}{the type of request to make, GET, POST or PATCH}
}
\value{
httr response object
}
\description{
Perform a get request to a url using a javascript web token for authentication
}
\examples{
\dontrun{
# this function is interactive and asks the user for a password
ices_request_jwt("GET", "https://taf.ices.dk/vms/api/gearwidths")
ices_get_jwt("https://taf.ices.dk/vms/api/gearwidths")
}
}
\seealso{
\code{\link[icesConnect]{ices_token}}
\code{\link[httr]{GET}},\code{\link[httr]{add_headers}},\code{\link[httr]{stop_for_status}},\code{\link[httr]{status_code}}
}
