% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHLdata.R
\name{getHLdata}
\alias{getHLdata}
\title{length based data}
\usage{
getHLdata(survey, year, quarter)
}
\arguments{
\item{survey}{the survey accronym e.g. NS-IBTS, BITS.}

\item{year}{the numeric year of the survey, e.g. 2010.}

\item{quarter}{the quarter of the year the survey took place, i.e. 1, 2, 3 or 4.}
}
\value{
A data.frame.
}
\description{
Returns length-based information such as measured length, individual counts,
  and subfactors of sampled species.
}
\examples{
# read length data
hldata <- getHLdata(survey = "NS-IBTS", year = 2016, quarter = 1)
str(hldata)

}
\author{
Colin Millar.
}
\seealso{
\code{\link{getSurveyList}} returns the acronyms for available surveys.

\code{\link{getSurveyYearList}} returns the years available for a given survey.

\code{\link{getSurveyYearQuarterList}} returns the quarters available for a given survey and year.

\code{\link{icesDatras-package}} gives an overview of the package.
}
\keyword{distribution}

