% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.taf.R
\name{write.taf}
\alias{write.taf}
\title{Write TAF Table to File}
\usage{
write.taf(x, file = NULL, dir = NULL, quote = FALSE,
  row.names = FALSE, fileEncoding = "UTF-8", underscore = TRUE, ...)
}
\arguments{
\item{x}{a data frame in TAF format.}

\item{file}{a filename.}

\item{dir}{an optional directory name.}

\item{quote}{whether to quote strings.}

\item{row.names}{whether to include row names.}

\item{fileEncoding}{character encoding for output file.}

\item{underscore}{whether automatically generated filenames (when
\code{file = NULL}) should use underscore separators instead of dots.}

\item{\dots}{passed to \code{write.csv}.}
}
\description{
Write a TAF table to a file.
}
\details{
Alternatively, \code{x} can be a list of data frames or a string vector of
object names, to write many tables in one call. The resulting files are named
automatically, similar to \code{file = NULL}.

The default value \code{file = NULL} uses the name of \code{x} as a filename,
so a data frame called \code{survey.uk} will be written to a file called
\file{survey_uk.csv} (when \code{underscore = TRUE}) or \file{survey.uk.csv}
(when \code{underscore = FALSE}).

The special value \code{file = ""} prints the data frame in the console,
similar to \code{write.csv}.
}
\examples{
\dontrun{
write.taf(catage.taf, "catage.csv")
catage <- read.taf("catage.csv")

write.taf(catage)
file.remove("catage.csv")
}

}
\seealso{
\code{\link{write.csv}} is the underlying function used to write a table to a
file.

\code{\link{read.taf}} reads a TAF table from a file into a data frame.

\code{\link{icesTAF-package}} gives an overview of the package.
}
