% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oanda_accounts}
\alias{oanda_accounts}
\title{Accounts for an OANDA fxTrade API Key}
\usage{
oanda_accounts(server = c("practice", "live"), apikey)
}
\arguments{
\item{server}{[default "practice"] select either the "practice" or "live" server
depending on the account type held with OANDA.}

\item{apikey}{(optional) string containing the OANDA fxTrade API key (personal
access token), or function that returns this string. Does not need to be
specified if already stored by oanda_set_key(). Can also be entered
interactively if not specified.}
}
\value{
A data.frame containing the list of accounts the authorization bearer
    token is authorized to access and their associated properties.
}
\description{
Return list of accounts authorised to be accessed by an OANDA fxTrade API key
    (personal access token). Used by other OANDA functions to access API
    endpoints that require an account ID.
}
\details{
This function queries the OANDA fxTrade API for account details
    associated with the supplied API key.

    For further details please refer to the OANDA fxTrade API vignette by
    running: \code{vignette("xoanda", package = "ichimoku")}.
}
\examples{
\dontrun{
# OANDA fxTrade API key required to run this example:
oanda_accounts()
}

}
