% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{print.ichimoku}
\alias{print.ichimoku}
\title{Print Ichimoku Objects}
\usage{
\method{print}{ichimoku}(x, plot = TRUE, ...)
}
\arguments{
\item{x}{an object of class 'ichimoku'.}

\item{plot}{[default TRUE] set to FALSE to prevent automatic plotting of
the ichimoku cloud chart.}

\item{...}{additional arguments passed along to print and plot functions.}
}
\value{
The ichimoku object 'x' passed as parameter.
}
\description{
Custom print method for ichimoku objects.
}
\details{
This function is an S3 method for the generic function print() for
    class 'ichimoku'. It can be invoked by calling print(x) on an object 'x'
    of class 'ichimoku'.
}
\section{Further Details}{

    Please refer to the reference vignette by running:
    \code{vignette("reference", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")

print(cloud, max = 110, digits = 4)
print(cloud[100:110,], plot = FALSE, digits = 4)

}
