% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-conversion.R
\name{PolToCar}
\alias{PolToCar}
\alias{PolToCar,matrix-method}
\alias{PolToCar,numeric-method}
\alias{PolToCar,data.frame-method}
\title{Conversion of polar coordinates to 3d Cartesian coordinates}
\usage{
PolToCar(x, ...)

\S4method{PolToCar}{matrix}(x, radius = authRadius, origin = c(0, 0, 0))

\S4method{PolToCar}{numeric}(x, radius = authRadius, origin = c(0, 0, 0))

\S4method{PolToCar}{data.frame}(x, radius = authRadius, origin = c(0, 0, 0), long = NULL, lat = NULL)
}
\arguments{
\item{x}{(\code{matrix}, \code{numeric}, \code{data.frame}) A 2-column \code{numeric} matrix with the longitude/latitude data.}

\item{...}{Arguments passed to class-specific methods.}

\item{radius}{(\code{numeric}) The radius of the sphere. Defaults to the R2 radius of Earth (6371.007km).}

\item{origin}{(\code{numeric}) Vector with length \code{3}, the XYZ coordinates of the sphere center.}

\item{long}{(\code{character}) If \code{x} is a \code{data.frame}, then the column used as longitudes.}

\item{lat}{(\code{character}) If \code{x} is a \code{data.frame}, then the column used as latitudes.}
}
\value{
An xyz 3-column numeric \code{matrix}, \code{data.frame} or \code{numeric}, depending on the class of \code{x}.
}
\description{
The function uses basic trigonometric relationships to transform longitude/latitude coordinates on a sphere to xyz Cartesian coordinates.
}
\details{
The authalic mean radius of Earth (6371.007 km) is used by this function as a default. The origin is \code{c(0,0,0)}. The precision of these conversions is not exact (see example \code{c(0,90)} below),
but should be considered acceptable when applied at a reasonable scale (e.g. for global analyses using data above \code{10e-6} meters of resolution).
}
\examples{
longLat <- rbind(
  c(0,0),
  #note the precision here!
  c(0, 90),
  c(-45,12)
)
# matrix-method
xyz <- PolToCar(longLat)
# numeric-method
xyz2 <- PolToCar(longLat[1,])
# data.frame method
xyz3 <- PolToCar(as.data.frame(longLat))
}
