% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{arcpoints}
\alias{arcpoints}
\title{Calculation of points along an arc}
\usage{
arcpoints(p1, p2, breaks = 2, origin = c(0, 0, 0), onlyNew = FALSE,
  output = "cartesian", radius = authRadius)
}
\arguments{
\item{p1}{Numeric vector, XYZ or longitude-latitude coordinates of the first point along the arc.}

\item{p2}{Numeric vector, XYZ or longitude-latitude coordinates of the last point along the arc.}

\item{breaks}{Single positive integer, the number of points inserted between p1 and p2.}

\item{origin}{Numeric vector, The center of the circle in XYZ coordinates (default is 0,0,0).}

\item{onlyNew}{Logical value whether of p1 and p2 should be omitted from the result or not.}

\item{output}{Character value, the coordinate system of the output points. Can either be \code{"polar"} for
longitude-latitude or \code{"cartesian"} for XYZ data.}

\item{radius}{Numeric value, the radius of the circle in case the input points have only polar coordinates.
Unused when XYZ coordinates are entered. Defaults to the authalic radius of Earth ca. 6371.007km.}
}
\value{
Either an XYZ or a long-lat numeric matrix.
}
\description{
This function calculates points along an arc between two points and and a circle center.
}
\details{
The function always returns the smaller arc, with angle alpha < pi.
}
\examples{
# empty plot
plot(NULL, NULL, xlim=c(-180, 180), ylim=c(-90,90))
# then endpoints of the arc
point1<-c(-45,-70)
point2<-c(130,65)
points(arcpoints(point1, point2, breaks=70, output="polar"))

}

