% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_support.R
\name{Charbin}
\alias{Charbin}
\title{Character vector to binary vector.}
\usage{
Charbin(resp, alts, n.alts, no.choice = FALSE)
}
\arguments{
\item{resp}{String vector containing input responses}

\item{alts}{String vector containing all possible alternatives. The order
should be the same as the order of the design matrix.}

\item{n.alts}{The number of alternatives per choice set.}

\item{no.choice}{Logical value indicating whether a no.choice option is
provided or not. The default = \code{FALSE}.}
}
\value{
A binary response vector with length equal to \code{length(resp) *
  length(n.alts)}.
}
\description{
Transforms a character vector with responses into a binary vector. Each
alternative in each choice set wil be either 0 or 1. If the
alternative was not chosen 0, and 1 if it was. The function can be used for example in a
shiny application to transform the response vector received from
\code{\link[shiny]{radioButtons}} into a numeric vector that can be used for
estimation.
}
\details{
The \code{n.alts} denotes the number of alternatives a respondent could
choose from, without counting a possible no choice option.

If \code{no.choice} is \code{TRUE} the first alternative specified in
\code{alts} will be treated as a no choice option. If the no choice option
was chosen all alternatives are zero for that choice set.
}
\examples{
\donttest{
# Observed Responses 
resp <- c("alt1", "alt3", "alt2", "no.choice", "alt1") 
# All possible alternatives 
alts <- c("no.choice", "alt1", "alt2", "alt3")
# 3 alternatives + no.choice 
Charbin(resp = resp, alts = alts, n.alts = 3, no.choice = TRUE)
}
}
